jQuery(document).ready(function($) {
    // Initialize color pickers
    $('.dbdp-color-field').wpColorPicker({
        change: function(event, ui) {
            updatePreview();
        }
    });
    
    // Update preview button in real-time
    function updatePreview() {
        var buttonColor = $('#dbdp_download_button_color').val();
        var hoverColor = $('#dbdp_download_button_hover_color').val();
        var textColor = $('#dbdp_download_button_text_color').val();
        var borderRadius = $('#dbdp_button_border_radius').val() + 'px';
        var buttonText = $('#dbdp_download_button_text').val();
        var padding = $('#dbdp_button_padding').val().split(' ');
        
        var verticalPadding = padding[0] ? padding[0] + 'px' : '12px';
        var horizontalPadding = padding[1] ? padding[1] + 'px' : '24px';
        
        $('#dbdp-preview-button').css({
            'background-color': buttonColor,
            'color': textColor,
            'border-radius': borderRadius,
            'padding': verticalPadding + ' ' + horizontalPadding
        }).text(buttonText);
        
        // Add hover effect preview
        $('#dbdp-preview-button').off('mouseenter mouseleave').hover(
            function() {
                $(this).css('background-color', hoverColor);
            },
            function() {
                $(this).css('background-color', buttonColor);
            }
        );
    }
    
    // Update preview on input changes
    $('#dbdp_download_button_text, #dbdp_button_border_radius, #dbdp_button_padding').on('input', function() {
        updatePreview();
    });
    
    // Initial preview update
    updatePreview();
});