<?php
defined('BASEPATH') OR exit('No direct script access allowed');

$config['template'] = [
    'form' => [
        'class_element'            => 'form-control',
        'class_element_select'            => 'form-control automatic-selection',
        'class_element_checkbox'   => 'form-check-input',
        'class_element_editor'     => 'form-control plugin_editor',
        'class_element_datepicker' => 'form-control datepicker',
        'class_element_text_emoji' => 'form-control text-emoji',
    ], 
    'datetime' => [
        'long' => 'Y-m-d H:i:s',
        'short' => 'Y-m-d',
    ],
    'news' => [
        'new_services'      => ['name' => 'New services',      'class' => 'btn-info'],
        'disabled_services' => ['name' => 'Disabled services', 'class' => 'btn-orange'],
        'updated_services'  => ['name' => 'Updated services',  'class' => 'btn-lime'],
        'announcement'      => ['name' => 'Announcement',      'class' => 'btn-primary'],
    ],
    'status' => [
        '1'      => ['name' => 'Active',   'class' => 'bg-indigo', 'class-badge' => 'bg-indigo-lt'],
        '0'      => ['name' => 'Deactive', 'class' => 'bg-orange', 'class-badge' => 'bg-orange-lt'],
        '2'      => ['name' => 'Unknow',   'class' => 'bg-orange', 'class-badge' => 'bg-orange-lt'],
        '3'      => ['name' => 'All',      'class' => 'bg-azure'],
    ],
    'tickets_status' => [
        'pending'     => ['name' => 'Pending',  'class' => 'bg-purple', 'class-badge' => 'bg-purple-lt'],
        'answered'    => ['name' => 'Answered', 'class' => 'bg-green',  'class-badge' => 'bg-secondary'],
        'closed'      => ['name' => 'Closed',   'class' => 'bg-indigo', 'class-badge' => 'bg-indigo-lt'],
        'all'         => ['name' => 'All',      'class' => 'bg-azure'],

    ], 
    'order_status' => [
        'all'             => ['name' => 'All',       'class' => 'bg-purple', 'class-badge' => 'bg-purple'],
        'active'          => ['name' => 'Active',       'class' => 'bg-purple', 'class-badge' => 'bg-green'],
        'completed'       => ['name' => 'Completed',    'class' => 'bg-green',  'class-badge' => 'bg-indigo'],
        'processing'      => ['name' => 'Processing',   'class' => 'bg-indigo', 'class-badge' => 'bg-blue'],
        'inprogress'      => ['name' => 'In progress',   'class' => 'bg-indigo', 'class-badge' => 'bg-cyan'],
        'pending'         => ['name' => 'Pending',      'class' => 'bg-indigo', 'class-badge' => 'bg-green'],
        'partial'         => ['name' => 'Partial',      'class' => 'bg-indigo', 'class-badge' => 'bg-pink'],
        'canceled'        => ['name' => 'Canceled',     'class' => 'bg-secondary', 'class-badge' => 'bg-secondary'],
        'error'           => ['name' => 'Error',        'class' => 'bg-red', 'class-badge' => 'bg-red'],
        'fail'            => ['name' => 'Fail',         'class' => 'bg-red', 'class-badge' => 'bg-red'],
        'paused'          => ['name' => 'Paused',     'class' => 'bg-red', 'class-badge' => 'bg-red'],
        'expired'         => ['name' => 'Expired',     'class' => 'bg-red', 'class-badge' => 'bg-red'],
        'awaiting'        => ['name' => 'Awaiting',     'class' => 'bg-lime', 'class-badge' => 'bg-lime'],
        'rejected'        => ['name' => 'Rejected',     'class' => 'bg-secondary', 'class-badge' => 'bg-secondary'],
        'refunded'        => ['name' => 'Refunded',     'class' => 'bg-indigo', 'class-badge' => 'bg-indigo'],
        'approved'        => ['name' => 'Approved',     'class' => 'bg-indigo', 'class-badge' => 'bg-indigo'],
    ],  
    'transactions_status' => [
        '-1'     => ['name' => 'Cancelled', 'class' => 'bg-red',    'class-badge' => 'bg-red'],
        '1'      => ['name' => 'success',      'class' => 'bg-indigo', 'class-badge' => 'bg-indigo-lt'],
        '0'      => ['name' => 'Waiting',   'class' => 'bg-orange', 'class-badge' => 'bg-orange-lt'],
        '2'      => ['name' => 'Unknown',    'class' => 'bg-orange', 'class-badge' => 'bg-orange-lt'],
        '3'      => ['name' => 'All',      'class' => 'bg-azure'],
    ],
    'bank_transactions_status' => [
        '-1'     => ['name' => 'Cancelled', 'class' => 'bg-red',    'class-badge' => 'bg-red'],
        '1'      => ['name' => 'success',      'class' => 'bg-indigo', 'class-badge' => 'bg-indigo-lt'],
        '0'      => ['name' => 'Waiting',   'class' => 'bg-orange', 'class-badge' => 'bg-orange-lt'],
        '2'      => ['name' => 'Unknown',    'class' => 'bg-orange', 'class-badge' => 'bg-orange-lt'],
        '3'      => ['name' => 'All',      'class' => 'bg-azure'],
    ],
    'button' => [ 
        'edit'         => ['name' => 'Edit',   'class' => 'ajaxModal',      'icon' => 'fe fe-edit', 'route-name' => '/update/'],
        'edit2'         => ['name' => 'Edit',   'class' => '',      'icon' => 'fe fe-edit', 'route-name' => '/update/'],
        'delete'       => ['name' => 'Delete', 'class' => 'ajaxDeleteItem', 'icon' => 'fe fe-trash-2', 'route-name' => '/delete/'],
        'view_user'    => ['name' => 'View User', 'class' => 'ajaxViewUser', 'icon' => 'fe fe-eye', 'route-name' => '/view_user/'],
        'view_invoice'    => ['name' => 'View invoice', 'class' => '', 'icon' => 'fe fe-eye', 'route-name' => '/view_invoice/'],
        'view'         => ['name' => 'View', 'class' => 'ajaxModal', 'icon' => 'fe fe-eye', 'route-name' => '/view/'],
        'more_detail'  => ['name' => 'More detail', 'class' => 'ajaxModal', 'icon' => 'fe fe-help-circle', 'route-name' => '/info/'],
        'set_password'  => ['name' => 'Set Password', 'class' => 'ajaxModal', 'icon' => 'fe fe-lock', 'route-name' => '/set_password/'],
        'add_funds'     => ['name' => 'Add Funds', 'class' => 'ajaxModal', 'icon' => 'fe fe-dollar-sign', 'route-name' => '/add_funds/'],
        'set_balance'   => ['name' => 'Set balance', 'class' => 'ajaxModal', 'icon' => 'fe fe-credit-card', 'route-name' => '/edit_funds/'],
        'send_mail'     => ['name' => 'Send Mail', 'class' => 'ajaxModal', 'icon' => 'fe fe-mail', 'route-name' => '/mail/'],
        'balance'       => ['name' => 'Update balance', 'class' => 'ajaxUpdateApiProvider', 'icon' => 'fe fe-dollar-sign', 'route-name' => '/balance/'],
        'sync_services' => ['name' => 'Sync services', 'class' => 'ajaxModal', 'icon' => 'fe fe-refresh-cw', 'route-name' => '/sync_services/'],
        'services'      => ['name' => 'Services Lists', 'class' => '', 'icon' => 'fe fe-list', 'route-name' => '/services/'],
        'resend'        => ['name'  => 'Resend Order', 'class' => '', 'icon' => 'fe fe-refresh-cw', 'route-name' => '/resend/'],
    ],
    'bulk_action' => [
        'delete'   => ['name' => 'Delete', 'class' => 'ajaxActionOptions', 'icon' => 'fe fe-trash-2',      'route-name' => '/bulk_action/'],
        'empty'    => ['name' => 'Empty The Data', 'class' => 'ajaxActionOptions', 'icon' => 'fe fe-trash-2',      'route-name' => '/bulk_action/'],
        'deactive' => ['name' => 'Deactive All', 'class' => 'ajaxActionOptions', 'icon' => 'fe fe-x-square',     'route-name' => '/bulk_action/'],
        'active'   => ['name' => 'Active', 'class' => 'ajaxActionOptions', 'icon' => 'fe fe-check-square', 'route-name' => '/bulk_action/'],
        'pending'  => ['name' => 'Mark as Pending',  'class' => 'ajaxActionOptions', 'icon' => 'fe fe-navigation',  'route-name' => '/bulk_action/'],
        'closed'   => ['name' => 'Mark as Closed',   'class' => 'ajaxActionOptions', 'icon' => 'fe fe-lock',        'route-name' => '/bulk_action/'],
        'answered' => ['name' => 'Mark as Answered', 'class' => 'ajaxActionOptions', 'icon' => 'fe fe-check',       'route-name' => '/bulk_action/'],
        'unread'   => ['name' => 'Mark as Unread', 'class' => 'ajaxActionOptions', 'icon' => 'fe fe-mail',       'route-name' => '/bulk_action/'],
        'csv'      => ['name' => 'Export CSV',   'class' => '', 'icon' => 'fe fe-download',  'route-name' => '/export/'],
        'excel'    => ['name' => 'Export excel', 'class' => '', 'icon' => 'fe fe-download',  'route-name' => '/export/'],
        'pending'      => ['name' => 'Pending', 'class' => 'ajaxActionOptions', 'icon' => 'fe fe-clock', 'route-name' => '/bulk_action/'],
        'inprogress'   => ['name' => 'In progress', 'class' => 'ajaxActionOptions', 'icon' => 'fe fe-loader', 'route-name' => '/bulk_action/'],
        'completed'    => ['name' => 'Completed', 'class' => 'ajaxActionOptions', 'icon' => 'fe fe-check-square', 'route-name' => '/bulk_action/'],
        'resend'       => ['name' => 'Resend Order', 'class' => 'ajaxActionOptions', 'icon' => 'fe fe-refresh-cw', 'route-name' => '/bulk_action/'],
        'cancel'       => ['name' => 'Cancel and Refund', 'class' => 'ajaxActionOptions', 'icon' => 'fe fe-x', 'route-name' => '/bulk_action/'],
        'rejected'     => ['name' => 'Rejected', 'class' => 'ajaxActionOptions', 'icon' => 'fe fe-x', 'route-name' => '/bulk_action/'],
        'paused'       => ['name' => 'Paused', 'class' => 'ajaxActionOptions', 'icon' => 'fe fe-alert-triangle', 'route-name' => '/bulk_action/'],
        'copy_id'      => ['name' => 'Copy to Clipboard (ID)', 'class' => 'ajaxActionOptions', 'icon' => 'fe fe-copy', 'route-name' => '/bulk_action/'],
    ],
    'search_field' => [
        'all'           => ['name' => 'All'],
        'id'            => ['name' => 'ID'],
        'email'         => ['name' => 'Email'],
        'name'          => ['name' => 'Name'],
        'order_id'      => ['name' => 'Order ID'],
        'sort'          => ['name' => 'Sort'],
        'question'      => ['name' => 'Question'],
        'answer'        => ['name' => 'Answer'],
        'title'         => ['name' => 'Title'],
        'description'    => ['name' => 'Description'],
        'ip'             => ['name' => 'IP address'],
        'history_ip'     => ['name' => 'History ip'],
        'country'        => ['name' => 'Location'],
        'first_name'     => ['name' => 'First name'],
        'last_name'      => ['name' => 'Last name'],
        'username'      => ['name'  => 'Username'],
        'transaction_id' => ['name' => 'Transaction id'],
        'note'           => ['name' => 'Note'],
        'subject'        => ['name' => 'Subject'],
        'api_service_id' => ['name' => 'API service id'],
        'api_order_id'   => ['name' => 'API Order id'],
        'service_id'     => ['name' => 'Service id'],
        'link'           => ['name' => 'Link'],
        'customer_name'  => ['name' => 'Customer Name'],
        'customer_email' => ['name' => 'Customer Email'],
        'ip' => ['name' => 'IP address'],
        'domain' => ['name' => 'Domain'],
        'support_mail' => ['name' => 'Email'],
        'code' => ['name' => 'Code'],
        'plans' => ['name' => 'Plans'],
        'transaction_id' => ['name' => 'Transaction ID'],
        'type' => ['name' => 'Payment method'],
        'device_key' => ['name' => 'Device key'],
        'device_name' => ['name' => 'Device name'],
        'device_ip' => ['name' => 'Device Ip'],
        'user_email' => ['name' => 'User Email'],
    ],
    'service_type' => [
        'default'                 => 'Default',
        'subscriptions'           => 'Subscriptions',
        'custom_comments'         => 'Custom comments',
        'custom_comments_package' => 'Custom comments package',
        'mentions_with_hashtags'  => 'Mentions with hashtags',
        'mentions_custom_list'    => 'Mentions custom list',
        'mentions_hashtag'        => 'Mentions hashtag',
        'mentions_user_followers' => 'Mentions user followers',
        'mentions_media_likers'   => 'Mentions media likers',
        'package'                 => 'Package',
        'comment_likes'           => 'Comment likes',
    ]
];

$config['config'] = [
    'button' => [
        'default'          => ['edit', 'delete'],
        'language'         => ['edit2', 'delete'],
        'order'            => ['edit', 'resend' ,'delete'],
        'news'             => ['edit', 'view' ,'delete'],
        'dripfeed'         => ['edit', 'resend' ,'delete'],
        'subscriptions'    => ['edit', 'resend' ,'delete'],
        'tickets'          => ['delete'],
        'category'         => ['edit', 'delete'],
        'payments'         => ['edit'],
        'provider'         => ['edit', 'balance', 'sync_services', 'services','delete'],
        'subscribers'      => ['delete', 'send_mail'],
        'users'            => ['edit', 'view_user', 'add_funds', 'set_password', 'send_mail', 'more_detail', 'delete',],
        'users_banned_ip'  => ['edit', 'delete'],
        'invoice'  => ['edit', 'delete','view_invoice'],
    ],
    'status' => [
        'default'  => [
            '0' => 'inactive', 
            '1' => 'active'
        ],
        'transactions'  => [
            '-1' => 'waiting', 
            '0' => 'pending', 
            '1' => 'paid'
        ],
        'bank_transactions'  => [
            '-1' => 'waiting', 
            '0' => 'pending', 
            '1' => 'paid'
        ],
        'tickets'  => [
            'pending'   => 'pending', 
            'answered'  => 'answered', 
            'closed'    => 'closed'
        ],
        'order'          => ['all', 'processing', 'inprogress', 'pending', 'completed', 'partial', 'canceled', 'error', 'fail'],
        'dripfeed'       => ['all', 'active', 'completed',  'canceled'],
        'subscriptions'  => ['all', 'active', 'paused', 'expired', 'completed', 'error'],
        'refill'         => ['all', 'pending', 'awaiting', 'inprogress', 'rejected', 'completed'],
    ],

    'search' => [
        'default'         => ['all', 'name'],
        'payments'        => ['name'],
        'faqs'            => ['question', 'answer'],
        'news'            => ['description'],
        'blogs'            => ['description','title'],
        'subscribers'     => ['email', 'ip', 'country'],
        'users'           => ['email', 'first_name', 'last_name', 'history_ip'],
        'users_activity'  => ['email', 'first_name', 'last_name', 'ip'],
        'users_banned_ip' => ['ip', 'description'],
        'tickets'         => ['id', 'email', 'subject'],
        'provider'        => [ 'name'],
        'subscriptions'   => [ 'id', 'api_order_id', 'username', 'email'],
        'refill'          => [ 'id', 'order_id', 'link', 'email'],
        'affiliates'      => [ 'email'],
        'coupon'          =>  ['all','code','description'],
        'invoice'          => ['all','customer_name','customer_email'],
        'domain'          =>  ['all','ip','domain','support_mail'],
        'devices'          =>  ['all','device_ip','device_key','user_email'],
        'plans'          =>  ['all','name'],
        'transactions'   =>  ['all','transaction_id','type'],
    ],
    'bulk_action' => [
        'default'          => ['active', 'deactive', 'delete'],
        'services'         => ['active', 'deactive', 'delete_custom_rates', 'delete'],
        'tickets'          => ['pending', 'answered', 'unread', 'closed', 'delete'],
        'category'         => ['active', 'deactive', 'delete'],
        'payments'         => ['active', 'deactive'],
        'users'            => ['active', 'deactive', 'csv', 'excel', 'delete'],
        'users_activity'   => ['delete', 'empty'],
        'users_banned_ip'  => ['delete', 'empty'],
        'subscribers'      => ['csv', 'excel', 'delete'],
        'transactions'     => [],
        'order'            => ['pending', 'inprogress', 'completed', 'resend', 'cancel', 'copy_id', 'copy_api_order_id'],
        'dripfeed'         => ['completed', 'cancel'],
        'refill'           => ['completed', 'rejected', 'copy_order_id', 'copy_api_order_id', 'copy_api_refill_id'],
        'subscriptions'    => ['active', 'completed', 'paused', 'cancel'],
    ],
];